import hevs.graphics.FunGraphics;

import java.awt.Color;

/**
 * Class using {@link FunGraphics} class to draw a dotted Flag.
 */
public class DottedFlagSolution {

	// Constant parameters
	final static int GRAPHICS_WIDTH = 640;
	final static int GRAPHICS_HEIGHT = 480;	
	final static int RADIUS = 8;
	final static int START_X = 15;
	final static int START_Y = 35;

	// Display surface to draw on
	public static FunGraphics display;

	public static void drawDisc(int radius, int Cx, int Cy, Color c){
		// Sets the color
		display.setColor(c);
		
		// Draw a disc
		for (int x = 0; x < GRAPHICS_WIDTH; x++){
			for (int y = 0; y < GRAPHICS_HEIGHT; y++){
				double distance = (Cx - x) * (Cx - x) + (Cy - y) * (Cy - y);
				
				if (distance <= radius*radius){
					display.setPixel(x, y);
				}
			}
		}
	}
	
	public static void fastDrawDisc(int radius, int Cx, int Cy, Color c){
		// Sets the colors
		display.setColor(c);
		
		// Check only the pixels in the direct neighbourhood of the circle
		for (int x = Cx - radius; x < Cx + radius; x++){
			for (int y = Cy - radius; y < Cy + radius; y++){
			
				// Check if in bounds
				if(x > 0 && x < GRAPHICS_WIDTH && y < GRAPHICS_HEIGHT && y > 0){
					// Draw circle
					double distance = (Cx - x) * (Cx - x) + (Cy - y) * (Cy - y);
				
					if (distance <= radius*radius){
						display.setPixel(x, y);
					}
				}
			}
		}
	}
	
	/**
	 * Program entry point
	 */
	public static void main(String[] args) {
		// Create and set the windows up
		display = new FunGraphics(GRAPHICS_WIDTH, GRAPHICS_HEIGHT);
				
		long now = System.currentTimeMillis();
		 
		final int SPACE = 40;	// The space required between circles
		final int OFFSET = 20;  // Offset between the different circles
		
		for(int i = 0; i < GRAPHICS_WIDTH / SPACE; i++){
			for(int j = 0; j < GRAPHICS_HEIGHT / SPACE; j++){
				fastDrawDisc(RADIUS, START_X + i * SPACE, START_Y + j * SPACE, Color.blue);
				fastDrawDisc(RADIUS, START_X + OFFSET +i * SPACE, START_Y + j * SPACE, Color.green);
				fastDrawDisc(RADIUS, START_X + i * SPACE, START_Y + OFFSET + j * SPACE, Color.black);
				fastDrawDisc(RADIUS, START_X + OFFSET + i * SPACE, START_Y + OFFSET + j * SPACE, Color.red);
			}
		}
		
		long after = System.currentTimeMillis();
		long duration = after-now;
		
		System.out.println("Duration of the display : " + duration + " ms");
	}
}