public class Polygon {

	/**
	 * @param n Number of sides of the polygon
	 * @param r Radius of the polygon
	 * @return The basis of a triangle of a n-sided polygon with radius r
	 */
	public static double side(int n, double r) {
		double alpha = 360.0 / n / 2.0;
		double alpha_in_radians = alpha * Math.PI / 180.0;
		double s = 2.0 * r * Math.sin(alpha_in_radians);
		return s;
	}

	/**
	 * @param n Number of sides of the polygon
	 * @param r Radius of the polygon
	 * @return The height of a triangle of a n-sided polygon with radius r
	 */
	public static double height(int n, double r) {
		double alpha = 360.0 / n / 2.0;
		double alpha_in_radians = alpha * Math.PI / 180.0;
		double h = r * Math.cos(alpha_in_radians);
		return h;
	}

	/**
	 * @param n Number of sides of the polygon
	 * @param r Radius of the polygon
	 * @return The area of a triangle of a n-sided polygon with radius r
	 */
	public static double compute_triangle_area(int n, double r) {
		return side(n, r) * height(n, r) * 2.0;
	}

	public static void main(String args[]) {
		
		int n = 4; // The number of sides of the polygon 
		double r = Math.sqrt(2) * 5.0; // The radius of the polygon

		// Compute the area of a triangle of the polygon
		double area_triangle = compute_triangle_area(n, r);

		// Get the complete area of the polygon
		double polygon_area = area_triangle * n;

		// Display it
		System.out.println("The area of the polygon with " + n
				+ " sides and radius " + r + " is " + polygon_area);
	}
}
