package labs.lab06_hangman;

import hevs.utils.Input;

/**
 * This class contains the logics related to the core
 * of the HangMan game. 
 * @author Pierre-Andre Mudry
 * @date 2011
 */
class WordManager {
	private String secretWord;
	private String userWord;
	
	public void askSecretWordG() {				
		secretWord = Dialogs.getHiddenString("Enter the secret word");
		secretWord = secretWord.toLowerCase();

		userWord = "";
		
		for (int i = 0; i < secretWord.length(); i++) {
			userWord = userWord + "*";
		}
	}
	
	/**
	 * Asks the user for the secret word
	 */
	public void askSecretWord() {
		System.out.print("Enter the secret word : ");
		secretWord = Input.readString();
		secretWord = secretWord.toLowerCase();

		userWord = "";
		
		for (int i = 0; i < secretWord.length(); i++) {
			userWord = userWord + "*";
		}
	}
	
	// Get the word the user has found so far
	public String getUserWord(){
		return userWord;
	}
	
	/**
	 * Controls if the given letter is present in the secret word.
	 * If yes, the user word stars corresponding to the letter are 
	 * uncovered.
	 * 
	 * @param c the letter to be checked
	 * @return true if the letter c is present
	 */
	public boolean checkLetter(char c) {
		boolean letterPresent = false;
				
		// Replace all occurrences of the given letter
		if (secretWord.indexOf(c) != -1) {			
			String tmp = "";
			
			for (int i = 0; i < secretWord.length(); i++) {
				char secretLetter = secretWord.charAt(i);
				if (secretLetter == c){
					letterPresent = true;
					tmp += c;
				}
				else
					tmp += userWord.charAt(i);
			}
			
			userWord = tmp;
		}
		
		return letterPresent;
	}
	
	/**
	 * @return true if the user word does not contain any more *
	 */
	public boolean isWordComplete(){
		return userWord.contains("*") == false;
	}
}