package labs.lab06_hangman;

import java.awt.Color;

import hevs.graphics.FunGraphics;
import hevs.utils.Input;

/**
 * Hangman game for lab 7, version 2.1 with more classes and
 * graphical interface.
 * 
 * @author <a href='mailto:pandre.mudry&#64;hevs.ch'> Pierre-André Mudry</a>
 * @version 1.0
 */

public class Hangman {

	private final int MAX_STEPS = 8;
	private final boolean USE_GUI = true;
	
	private int currentStep = 0;

	// Used for the graphical view
	private FunGraphics g;
	private WordManager w;

	public boolean playG() {
		char c = Dialogs.getChar("Enter your letter : ");

		if (w.checkLetter(c) == false) {
			currentStep++;
			System.out.println("The letter " + c + " is not present ! Wrong tries " + currentStep + "/" + MAX_STEPS);
		}

		System.out.println(w.getUserWord());

		return currentStep < MAX_STEPS;
	}

	public boolean play() {
		System.out.print("Enter a character : ");
		char c = Input.readChar();

		if (w.checkLetter(c) == false) {
			currentStep++;
			System.out.println("The letter " + c + " is not present ! Wrong tries " + currentStep + "/" + MAX_STEPS);
		}

		System.out.println(w.getUserWord());

		return currentStep < MAX_STEPS;
	}

	/**
	 * This method takes care of the graphical view
	 */
	public void updateGraphicsView() {
		g.setColor(Color.white);
		g.drawFillRect(20, 30, 100, 30);
		g.setColor(Color.black);
		g.drawString(20, 50, "Word : " + w.getUserWord());

		switch (currentStep) {
		case 1:
			g.drawLine(110, 210, 120, 190);
			g.drawLine(130, 210, 120, 190);
			break;
		case 2:
			g.drawLine(120, 190, 120, 100);
			break;
		case 3:
			g.drawLine(120, 100, 180, 100);
			break;
		case 4:
			g.drawLine(180, 100, 180, 110);
			break;
		case 5:
			g.drawCircle(170, 110, 20);
			break;
		case 6:
			g.drawLine(180, 130, 180, 170);
			break;
		case 7:
			g.drawLine(180, 170, 170, 190);
			g.drawLine(180, 170, 190, 190);
			break;
		case 8:
			g.drawLine(180, 150, 170, 150);
			g.drawLine(180, 150, 190, 150);
			break;
		default:
			break;
		}

	}

	// Constructor
	Hangman() {
		// Creates the graphical window
		g = new FunGraphics(300, 300, 10, 10, "HangMan !", true);

		// Creates the word manager
		w = new WordManager();

		boolean gameActive = true;

		/**
		 * Game main loop
		 */
		while (gameActive) {
			// Ask a new word graphically
			if(USE_GUI)
				w.askSecretWordG();
			else
				// Ask a word in the console
				w.askSecretWordG();

			/**
			 * Ask questions until the user has won or lost
			 */
			while (true) {
				boolean r;
				// Play using input dialog
				if(USE_GUI)
					r = playG();
				else
					r = play();

				// Play using console dialog
				// boolean r = playG();

				// Graphic drawing
				updateGraphicsView();

				/*
				 * There are two ways to end the game : either the return value
				 * of the play() method is false or the userWord contains no
				 * more * in it. In the former case, the game is lost and in the
				 * latter, the game is won. In both cases, the game is finished.
				 */
				if (r == false || w.isWordComplete() == true) {
					break;
				}
			}

			// When we reach this point, the user has either won or lost
			if (w.isWordComplete() == true) {
				System.out.println("Congratulations, you've won !");
			} else {
				System.out.println("You've lost ! Sorry about that !");
			}

			// Ask the user if he/she desires to play again
			System.out.print("Would you like to play again (y/n) ? ");
			char c = Input.readChar();

			if (c == 'n' || c == 'N') {
				System.out.println("Good bye and thank you for playing !");
				gameActive = false;
			} else {
				g.clear();
				currentStep = 0;
			}
		}
	}

	public static void main(String[] args) {
		System.out.println("Hangman v2.1");
		System.out.println("************");
		Hangman game = new Hangman();
	}
}
